function KillerShape(trace)
% This function recognizes the traces acquired using the gesture recognition
% module. 
% trace is a X, Y column vector
% Example: >>load TOTAL.mat
%          >>KillerShape(sq6);

I=[]; %Image initialization
fin = size(trace,1);

for i=1:(fin-1)
    I = logical(func_DrawLine(logical(I), round(trace(i,1)+1), round(trace(i,2)+1), round(trace(i+1,1)+1), round(trace(i+1,2)+1), 1)); %put the trace into the image
end
II = logical(func_DrawLine(logical(I), round(trace(fin,1)+1), round(trace(fin,2)+1), round(trace(1,1)+1), round(trace(1,2)+1), 1)); %close the last point with the first one

aa=(imfill(logical(I),'holes')); %fill I
aaa=(imfill(logical(II),'holes')); %fill II

% here we compare the areas of aa and aaa to see if we have or not to close
% the figure
if sum(sum(aa))<(sum(sum(aaa))/3)
    aa=aaa;
end


clear II, aaa;

% here the image I is the filled image of the trace

init=regionprops(uint8(aa),'Image');
norm=init.Image;
taux=350/size(norm,1);
aa=imresize(logical(norm),taux);

% here aa is normalized and inside its bounding box

BX=regionprops(uint8(aa),'Centroid');
aa=imopen(logical(aa),strel('disk',8));
aa=bwlabel(logical(aa));
if max(max(aa))>1
   aa=bwselect(uint8(aa),BX.Centroid(1),BX.Centroid(2));
end

CX=regionprops(uint8(aa),'ConvexImage');

cc=CX.ConvexImage;


critere = sum(sum(aa))/numel(cc)
if critere<0.65
    disp('TRIANGLE')
end
if critere>0.65
    hEllipse = ellipsedraw(size(aa,1),size(cc,2),round(size(cc,1)/2),round(size(cc,2)/2),0);
    II=[];

for i=1:10:size(hEllipse,1)
II(round(hEllipse(i,1)+500),round(hEllipse(i,2)+500))=1;
end
fin=size(hEllipse,1);

for i=1:fin-1,II = func_DrawLine(uint8(II), round(hEllipse(i,1)+500), round(hEllipse(i,2)+500), round(hEllipse(i+1,1)+500), round(hEllipse(i+1,2)+500), 1);end
II = func_DrawLine(uint8(II), round(hEllipse(fin,1)+500), round(hEllipse(fin,2)+500), round(hEllipse(1,1)+500), round(hEllipse(1,2)+500), 1);
bb=(imfill(fliplr(logical(II)),'holes'));
  
AX=regionprops(uint8(bb),'ConvexImage');
ref_cerc=imresize(AX.ConvexImage,[size(cc,1) size(cc,2)])>0;
ref_square=ones(size(cc,1),size(cc,2));

critere2=sum(sum(xor(ref_cerc,ref_square).*cc));
critere3 =sum(sum(xor(ref_cerc,ref_square)))/(2.3);

sq=0;
laba=bwlabel(xor(ref_cerc,ref_square));
for i=1:4
    critere22=sum(sum((laba==i).*cc));
    critere33=sum(sum(laba==i))/2;
    if critere33<critere22
        sq=1;
    end
end

if sq==1
    disp('SQUARE')
end
if sq==0

if critere3< critere2
    disp('SQUARE')
end
if critere3 > critere2
    disp('CIRCLE')
end
end
end